/* ---------------------------------------------------- */
/* 					Piano - Noise 12 					*/
/* 					Ramin Jafarpour  					*/
/*    				www.ECA.ir    						*/
/* ---------------------------------------------------- */


#include "LPC17xx.h"
#include "TFTLCD.h"
#include "Touch.h"

#define C1 261
#define C2 293
#define C3 329
#define C4 349
#define C5 392
#define C6 440
#define C7 493

#define TIME_INTERVAL(X)	(125000/X - 1)
#define Sin_Wave_Len 200

extern unsigned short Piano_BMP[];
volatile unsigned short Timer0Cnt,Duration;

const unsigned short Sin_Wave[Sin_Wave_Len]=
{
 512, 528, 544, 560, 576, 592, 607, 623, 639, 654, 670,
 685, 700, 715, 729, 744, 758, 772, 786, 799, 812,
 825, 838, 850, 862, 874, 885, 896, 906, 916, 926,
 935, 944, 952, 960, 968, 975, 981, 988, 993, 998,
 1003, 1007, 1011, 1014, 1017, 1019, 1021, 1022, 1023,
 1023, 1022, 1021, 1019, 1017, 1014, 1011, 1007, 1003, 998,
 993, 988, 981, 975, 968, 960, 952, 944, 935, 926,
 916, 906, 896, 885, 874, 862, 850, 838, 825, 812,
 799, 786, 772, 758, 744, 729, 715, 700, 685, 670,
 654, 639, 623, 607, 592, 576, 560, 544, 528, 512,
 495, 479, 463, 447, 431, 416, 400, 384, 369, 353,
 338, 323, 308, 294, 279, 265, 251, 237, 224, 211,
 198, 185, 173, 161, 149, 138, 127, 117, 107, 97,
 88, 79, 71, 63, 55, 48, 42, 35, 30, 25,
 20, 16, 12, 9, 6, 4, 2, 1, 0, 0,
 0, 1, 2, 4, 6, 9, 12, 16, 20, 25,
 30, 35, 42, 48, 55, 63, 71, 79, 88, 97,
 107, 117, 127, 138, 149, 161, 173, 185, 198, 211,
 224, 237, 251, 265, 279, 294, 308, 323, 338, 353,
 369, 384, 400, 416, 431, 447, 463, 479, 495 , 512
};


void TIMER0_IRQHandler (void) 
{ 	
	LPC_TIM0->IR = 1; 
	LPC_TIM0->TC = 0;
	if (Duration)
	{
		LPC_DAC->DACR = ( Sin_Wave[Timer0Cnt] << 6); 
		if(++Timer0Cnt>=Sin_Wave_Len) 
		{
			Timer0Cnt=0;
			Duration--;
		}
	}
	return;	
}


void DACInit( void )
{
  /* setup the related pin to DAC output */
  LPC_PINCON->PINSEL1 = 0x00200000;	/* set p0.26 to DAC output */   
  return;
}

void TimerInit( void )
{
	Timer0Cnt = 0;
	LPC_TIM0->MR0 = TIME_INTERVAL(500);
	LPC_TIM0->MCR = 3;	
	NVIC_EnableIRQ(TIMER0_IRQn);	
	LPC_TIM0->TCR = 1; //Enable timer0	
}

void Play(unsigned short Tone,unsigned short Dur)
{
	Duration = Dur * 1 ;
	LPC_TIM0->TC = 0;
	LPC_TIM0->MR0 = TIME_INTERVAL(Tone);
}

int main(void)
{
	uint16_t X,Y;
	SystemInit();	
	TimerInit();
  	DACInit();
	
	LPC_GPIO0->FIODIR|=(1<<21);
	LPC_GPIO0->FIOSET=(1<<21);
	LPC_GPIO2->FIODIR0=0xFF;
	LPC_GPIO2->FIOPIN0=0x01;
	
	GLCD_Init();
  	GLCD_Clear(Red);
	GLCD_Bmp16 (  0,   0, 320,  240, Piano_BMP);
	TouchInit();	
	
    while (1) 
	{
		if (Touch(&X,&Y))
		{
			if (X>50)
			{
				if (Y<45)  Play (C1,100);
				else if (Y<90) Play (C2,100);
				else if (Y<135) Play (C3,100);
				else if (Y<180) Play (C4,100);
				else if (Y<225) Play (C5,100);
				else if (Y<270) Play (C6,100);
				else  Play (C7,100);
			}
		}
    } 
}
